using System;
using System.IO;
using System.Windows.Forms;
using System.CodeDom;
using System.Collections;
using System.ComponentModel;
using System.Diagnostics;
using Borland.Studio.ToolsAPI;
using BeWise.SharpBuilderTools.Gui;
using BeWise.SharpBuilderTools.Utils;

namespace BeWise.SharpBuilderTools
{
	public class OTAShell : BaseOTA
	{
		/**************************************************************/
		/*                        Protected
		/**************************************************************/

		protected void DoOpenShell(object aSender, EventArgs AEventArgs) {
			Process.Start(@"cmd.exe");
		}

		protected void DoOpenModuleFolder(object aSender, EventArgs AEventArgs) {
			IOTAModule _Module = OTAUtils.GetCurrentModule();

			if (_Module != null) {
				Process.Start(Path.GetDirectoryName(_Module.FileName));
			}
		}

		protected void DoOpenProjectFolder(object aSender, EventArgs AEventArgs) {
			IOTAProject _Project = OTAUtils.GetCurrentProject();

			if (_Project != null) {
				Process.Start(Path.GetDirectoryName(_Project.FileName));
			}
		}

		protected void DoOpenProjectGroupFolder(object aSender, EventArgs AEventArgs) {
			IOTAProjectGroup _ProjectGroup = OTAUtils.GetCurrentProjectGroup();

			if (_ProjectGroup != null) {
				Process.Start(Path.GetDirectoryName(_ProjectGroup.FileName));
			}
		}

		/**************************************************************/
		/*                         Public
		/**************************************************************/

		public override void IDERegister(out string[] aMenuNames, out int[] aMenuShortCuts) {
			IOTAMainMenuService _MenuService = null;
			IOTAMenuItem _MenuItem = null;

			_MenuService = (IOTAMainMenuService) BorlandIDE.GetService(typeof(IOTAMainMenuService));

			// Shell Menu
			_MenuItem = _MenuService.AddMenuItem(Consts.SHARP_BUILDER_TOOLS_MENU_NAME, OTAMenuItemLocation.otamlChild, "ShellMenu","Shell");
			_MenuItem.Enabled = true;

			// Open Shell
			_MenuItem = _MenuService.AddMenuItem("ShellMenu",
												 OTAMenuItemLocation.otamlChild,
												 "OpenShellMenu",
												 "Open Shell");
			_MenuItem.Enabled = true;
			_MenuItem.Executed += new EventHandler(DoOpenShell);

			// Sep
			_MenuItem = _MenuService.AddMenuItem("ShellMenu",
												 OTAMenuItemLocation.otamlChild,
												 "SepShell1",
												 "-");

			// Open Module Folder
			_MenuItem = _MenuService.AddMenuItem("ShellMenu",
												 OTAMenuItemLocation.otamlChild,
												 "OpenModuleFolderMenu",
												 "Open Module Folder");
			_MenuItem.Enabled = true;
			_MenuItem.Executed += new EventHandler(DoOpenModuleFolder);

			// Open Project Folder
			_MenuItem = _MenuService.AddMenuItem("ShellMenu",
												 OTAMenuItemLocation.otamlChild,
												 "OpenProjectFolderMenu",
												 "Open Project Folder");
			_MenuItem.Enabled = true;
			_MenuItem.Executed += new EventHandler(DoOpenProjectFolder);

			// Open Project Group
			_MenuItem = _MenuService.AddMenuItem("ShellMenu",
												 OTAMenuItemLocation.otamlChild,
												 "OpenProjectGroupFolderMenu",
												 "Open Project Group Folder");
			_MenuItem.Enabled = true;
			_MenuItem.Executed += new EventHandler(DoOpenProjectGroupFolder);

			aMenuNames = new string[] {""};
			aMenuShortCuts = new int[] {0};
		}
	}
}
